package elaborator;

import java.util.Map;

import elaborator.tests.*;
import elaborator.utils.*;

/**
 * L'adapter coincide con il modi di ritorno dei dati con il datagenerator
 * quindi qui non serve esplicitamente, ma se il sotto-ufficiale dovrà scrivere
 * un'interfaccia tra per i sensori dovremo modificare soltanto questo adapter
 * invece che il Receiver. L'esempio apposta è getPlanet di DataGen che qui
 * adatta al Receiver come getPlanetName;
 * 
 * @author koelio
 * @see DataGenerator
 * 
 */
public class AdapterSensorsInterface implements Receiver {

	DataGenerator testdata = new TestDataGenerator();

	@Override
	public int[] getTemps() {
		return testdata.getTemps();
	}

	@Override
	public int getDiameter() {
		return testdata.getDiameter();
	}

	@Override
	public Map<Double, String> getComposition() {
		return testdata.getComposition();
	}

	@Override
	public String getPlanetName() {
		return testdata.getPlanet();
	}

}
